package w83b.w83bOperacionesPaso.w83bIncidencias;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bBeans.W83bIncidenciasSubsanacionCambioBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bFichaIncidenciasAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaIncidencias.xls";
		InputStream inputStream = W83bFichaIncidenciasAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        W83bNuevaIncidenciasBean incidencia=(W83bNuevaIncidenciasBean)contexto.get("w83bNuevaIncidenciasFichaBean");
      
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
         
        HSSFHeader header = sheet.getHeader();
        header.setLeft(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.eleccionesSindicales",idioma));
        header.setRight(HSSFHeader.fontSize((short)6)+" "+W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        HSSFFooter footer = sheet.getFooter();
        footer.setCenter(HSSFFooter.fontSize((short)6) +((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(HSSFFooter.fontSize((short)6) + Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{HSSFFooter.page()}));
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);

        row = sheet.getRow((short)4); 
        cell = row.getCell((short)2);
        
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
 	   
		StringBuffer  tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
		cell.setCellValue(tituloImagenEu.toString());
	    cell = row.getCell((short)5); 
	    cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs"); 
       
        row = sheet.getRow((short)5); 
        cell = row.getCell((short)2);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)5); 
        cell.setCellValue(tituloImagenEs.toString());
        
       
        
        int n=6;
        //Titulo
        row = sheet.getRow((short)n+1); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.labels.ficha",idioma));

        //Datos del preaviso
        row = sheet.getRow((short)n+3); 
        cell = row.getCell((short)1); 
       
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datosbasicos",idioma));
        
        //fin Datos del preaviso
        row = sheet.getRow((short)n+4); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.numIncidencia",idioma)
        		+":  "+incidencia.getIncidenciaTerritorio()+"/"+incidencia.getIncidenciaAnyo()+"/"+incidencia.getIncidenciaNumero());
        
        row = sheet.getRow((short)n+4); 
        cell = row.getCell((short)5); 
        if(StringUtils.isEmpty(incidencia.getActaNumeroParcial())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.numActa",idioma)
        			+":  "+incidencia.getActaTerritorio()+"/"+incidencia.getActaAnyo()+"/"+incidencia.getActaNumero());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.numActa",idioma)
        			+":  "+incidencia.getActaTerritorio()+"/"+incidencia.getActaAnyoParcial()+"/"+incidencia.getActaNumeroParcial());        	
        }
        
        
        
        row = sheet.getRow((short)n+5); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fechaEntrada",idioma)
        		+":  "+incidencia.getFecEntrada());
        cell = row.getCell((short)5); 
        if(StringUtils.isNotEmpty(incidencia.getFecValidacion())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fechaValidacion",idioma)
        			+":  "+incidencia.getFecValidacion());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fechaValidacion",idioma)
        			+":  ");        	
        }
        
        row = sheet.getRow((short)n+6); 
        cell = row.getCell((short)1); 
        if(StringUtils.isNotEmpty(incidencia.getNumRegistroES())){
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fechaRegistro",idioma)
	        		+":  "+incidencia.getFecRegistro());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fechaRegistro",idioma)
        			+":  ");        	
        }
        
        if(StringUtils.isNotEmpty(incidencia.getNumRegistroES())){
	        cell = row.getCell((short)5); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.numRegistroES",idioma)
	        		+":  "+incidencia.getNumRegistroES().toUpperCase());
        }else{
        	cell = row.getCell((short)5); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.numRegistroES",idioma)
        			+":  ");        	
        }
          
        row = sheet.getRow((short)n+7); 
        cell = row.getCell((short)1);         
        String tipoSolicitante = "";//NOMPD
    	tipoSolicitante = incidencia.getTipoSolicitanteTxt();
    	if(StringUtils.isNotEmpty(tipoSolicitante)){
    		tipoSolicitante = tipoSolicitante.toUpperCase();
    	}else{
    		tipoSolicitante = "";    		
    	}
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipoSolicitanteTxt",idioma)
    			+":  "+tipoSolicitante);
    	int tamanyoTexto = cell.getStringCellValue().length();
    	if(93<tamanyoTexto){
    		row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
    	}                 
        
    	row = sheet.getRow((short)n+8); 
    	cell = row.getCell((short)1);         
    	String dniSolicitante = "";//NOMPD
    	if(StringUtils.isNotEmpty(incidencia.getDniSolicitante())){
    		dniSolicitante = incidencia.getDniSolicitante();//NOMPD  		
    	}
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.dniSolicitanteTxt",idioma)
    			+":  "+dniSolicitante);
    	
    	row = sheet.getRow((short)n+9); 
    	cell = row.getCell((short)1);         
    	String nombreSolicitante = "";//NOMPD
    	nombreSolicitante = incidencia.getNombreSolicitante();
    	if(StringUtils.isNotEmpty(nombreSolicitante)){
    		nombreSolicitante = nombreSolicitante.toUpperCase();
    	}else{
    		nombreSolicitante = "";    		
    	}
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.nombreSolicitanteTxt",idioma)
    			+":  "+nombreSolicitante.toUpperCase());
    	tamanyoTexto = cell.getStringCellValue().length();
    	if(93<tamanyoTexto){
    		row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
    	}                 
    	
    	row = sheet.getRow((short)n+10); 
    	cell = row.getCell((short)1);         
    	String observaciones = "";//NOMPD
    	observaciones = incidencia.getObservaciones();
    	if(StringUtils.isEmpty(observaciones)){
    		observaciones = "";
    	}
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.observaciones",idioma)
    			+":  "+observaciones.toUpperCase());
    	tamanyoTexto = cell.getStringCellValue().length();
    	if(93<tamanyoTexto){
    		row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
    	}                 
    	
    	row = sheet.getRow((short)n+11); 
    	cell = row.getCell((short)1);         
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipologia",idioma)
    			+":  "+incidencia.getTipologiaIncidenciaTxt());
    	   
    	row = sheet.getRow((short)n+11); 
    	cell = row.getCell((short)5);    
    	
    	String validada = "";
    	
    	if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(incidencia.getValidada())){
    		validada = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
    	}else if(W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(incidencia.getValidada())){
    		validada = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();    		
    	}else{
    		validada = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.descartada",idioma).toUpperCase();    		
    	}
    	
    	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.validada",idioma)
    			+":  "+validada);
    	  
        
    	
        HSSFRow rowTemp = sheet.getRow((short)n+3);
        HSSFCellStyle estiloTemp;
        int numlinea=n+13;

        if (incidencia.getListaCambiosSubnacion().size()>0){
        	row = sheet.createRow((short)n+13); 
        	cell = row.createCell((short)1);
        	cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.labels.camposModificados",idioma));
        	sheet.addMergedRegion(new Region(n+13,Short.parseShort("1"),n+13,Short.parseShort("2")));//NOPMD
        	cell = row.createCell((short)2);
        	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        	
        	cell = row.createCell((short)3); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.valorAnterior",idioma));
        	sheet.addMergedRegion(new Region(n+13,Short.parseShort("3"),n+13,Short.parseShort("5")));//NOPMD
        	cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        	cell = row.createCell((short)4);
        	cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        	cell = row.createCell((short)5);
        	cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        	
        	cell = row.createCell((short)6); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.valorActual",idioma));
        	cell.setCellStyle(rowTemp.getCell((short)6).getCellStyle());
        	cell = row.createCell((short)7);
        	cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
        	sheet.addMergedRegion(new Region(n+13,Short.parseShort("6"),n+13,Short.parseShort("7")));//NOPMD
        
        	 List listaCambios=incidencia.getListaCambiosSubnacion();
        	 W83bIncidenciasSubsanacionCambioBean cambio=null;
             rowTemp = sheet.getRow((short)n+10);
             boolean valorNumerico=false;
             for (int i=0;i<listaCambios.size();i++){
            	 cambio=(W83bIncidenciasSubsanacionCambioBean)listaCambios.get(i);
             	row = sheet.createRow((short)++numlinea); 
             	  cell = row.createCell((short)1); 
                 sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("2")));//NOPMD
                 String valorAnterior = cambio.getCampoAnt(); 
                 String valorActual = cambio.getCampoActual(); 
                 if(StringUtils.isEmpty(valorAnterior)){
                	 valorAnterior = "";
                 }
                 if(StringUtils.isEmpty(valorActual)){
                	 valorActual = "";
                 }
                 if(W83bClsConstantes.inspeccionada.equals(cambio.getCodCampo())){
                	 if(W83bClsConstantes.NO_INSPECCIONADA.equals(valorAnterior)){
                		 valorAnterior = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
                	 }else{
                		 valorAnterior = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();                		 
                	 }
                	 if(W83bClsConstantes.NO_INSPECCIONADA.equals(valorActual)){
                		 valorActual = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
                	 }else{
                		 valorActual = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();                		 
                	 }
                 }

                 cell.setCellValue(cambio.getDescCampo());
                 
                 cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
                 cell = row.createCell((short)2); 
                 cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
                 tamanyoTexto =row.getCell((short)1).getStringCellValue().length()+cell.getStringCellValue().length();
                 sheet.addMergedRegion(new Region(numlinea,Short.parseShort("3"),numlinea,Short.parseShort("5")));//NOPMD
                 cell = row.createCell((short)3);
                 estiloTemp=rowTemp.getCell((short)3).getCellStyle();
               	
                 try {
                	 Integer.parseInt(valorAnterior);
                	 cell.setCellValue(W83bUtilidades.numero(valorAnterior));
                	 valorNumerico=true;
                	 } catch (NumberFormatException nfe){
                		 cell.setCellValue(valorAnterior);
                		 valorNumerico=false;
                	 }
                	 estiloTemp=rowTemp.getCell((short)3).getCellStyle();
                  	estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
                  	 cell.setCellStyle(estiloTemp);
                	 cell = row.createCell((short)4); 
                  
                    estiloTemp=rowTemp.getCell((short)4).getCellStyle();
                 	estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
                     cell.setCellStyle(estiloTemp);
                     cell = row.createCell((short)5);
                     estiloTemp=rowTemp.getCell((short)5).getCellStyle();
                  	estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
                 	cell.setCellStyle(estiloTemp); 	
                 if(!valorNumerico)
                 {
                	 if(tamanyoTexto<row.getCell((short)3).getStringCellValue().length()+row.getCell((short)4).getStringCellValue().length()+cell.getStringCellValue().length()){
                      	 tamanyoTexto = cell.getStringCellValue().length();
                       }
                 }
                   	
                 
                
                 sheet.addMergedRegion(new Region(numlinea,Short.parseShort("6"),numlinea,Short.parseShort("7")));//NOPMD
                 cell = row.createCell((short)6); 
                 try {
                	 Integer.parseInt(valorActual);
                	 	cell.setCellValue(W83bUtilidades.numero(valorActual));
                	 	
                	 } catch (NumberFormatException nfe){
                		 cell.setCellValue(valorActual);
                	 }
                estiloTemp=rowTemp.getCell((short)6).getCellStyle();
             	estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
                 cell.setCellStyle(estiloTemp);
                 cell = row.createCell((short)7);
                 estiloTemp=rowTemp.getCell((short)7).getCellStyle();
              	estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
             	cell.setCellStyle(estiloTemp); 
                 
                
                 if(32<tamanyoTexto){
                	 row.setHeightInPoints((short)(33*(tamanyoTexto/32)+1));
                 }
             }
             
             rowTemp = sheet.getRow((short)n+11);
             cell = row.getCell((short)1); 
             sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("2")));//NOPMD
             cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
             cell = row.getCell((short)2);
          	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
             tamanyoTexto = row.getCell((short)1).getStringCellValue().length()+cell.getStringCellValue().length();
             if(32<tamanyoTexto){
            	 row.setHeightInPoints((short)(33*(tamanyoTexto/32)+1));
             }
             
             cell = row.getCell((short)2);
         	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
             cell = row.getCell((short)3); 
             sheet.addMergedRegion(new Region(numlinea,Short.parseShort("3"),numlinea,Short.parseShort("5")));//NOPMD
             estiloTemp=rowTemp.getCell((short)3).getCellStyle();
          	 estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
             cell.setCellStyle(estiloTemp);
             cell = row.getCell((short)4);
             estiloTemp=rowTemp.getCell((short)4).getCellStyle();
        	 estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
            cell.setCellStyle(estiloTemp);
            
            cell = row.getCell((short)5);
            estiloTemp=rowTemp.getCell((short)5).getCellStyle();
      		estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
      		cell.setCellStyle(estiloTemp);
      		sheet.addMergedRegion(new Region(numlinea,Short.parseShort("6"),numlinea,Short.parseShort("7")));//NOPMD
             
      		cell = row.getCell((short)6);
            estiloTemp=rowTemp.getCell((short)6).getCellStyle();
       		estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
       		cell.setCellStyle(estiloTemp);
           
       		cell = row.getCell((short)7);
            estiloTemp=rowTemp.getCell((short)7).getCellStyle();
       		estiloTemp.setAlignment(HSSFCellStyle.ALIGN_LEFT); 
       		cell.setCellStyle(estiloTemp);
       		
      		
                  
             ++numlinea;

        }
        
        ++numlinea;
        ++numlinea;
        
        if (incidencia.getListaDelegados().size()>0){
        	List listaDelegados=incidencia.getListaDelegados();
        	W83bDelegadosBean delegado=null;
        	rowTemp = sheet.getRow((short)n+3);
        	row = sheet.createRow((short)numlinea); 
        	cell = row.createCell((short)1); 
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.baja",idioma));
    		cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
    		cell = row.createCell((short)2);
        	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("2")));//NOPMD
    		cell = row.createCell((short)3); 
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.dniDelegado",idioma));
    		cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
    		cell = row.createCell((short)4);
        	cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        	cell = row.createCell((short)5);
        	cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("3"),numlinea,Short.parseShort("5")));//NOPMD
    		cell = row.createCell((short)6); 
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.dniSustitutoDelegado",idioma));
    		cell.setCellStyle(rowTemp.getCell((short)6).getCellStyle());
    		cell = row.createCell((short)7);
        	cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
        	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("6"),numlinea,Short.parseShort("7")));//NOPMD
    		rowTemp = sheet.getRow((short)n+10);
    		
        	for (int i=0;i<listaDelegados.size();i++){
        		delegado=(W83bDelegadosBean)listaDelegados.get(i);
        		row = sheet.createRow((short)++numlinea); 
        		cell = row.createCell((short)1); 
        		String baja = "";
        		if(StringUtils.isNotEmpty(delegado.getFechaBaja())){
        			baja = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        		}else{
        			baja = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        			
        		}
        		cell.setCellValue(baja);
        		cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        		cell = row.createCell((short)2);
            	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
            	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("2")));//NOPMD
        		cell = row.createCell((short)3); 
        		cell.setCellValue(delegado.getDniDelegado().toUpperCase());
                cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
                
                cell = row.createCell((short)4);
            	cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
            	cell = row.createCell((short)5);
            	cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
            	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("3"),numlinea,Short.parseShort("5")));//NOPMD
        		cell = row.createCell((short)6); 
        		cell.setCellValue(delegado.getDniSustituto());
        		cell.setCellStyle(rowTemp.getCell((short)6).getCellStyle()); 
        		cell = row.createCell((short)7);
            	cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());
            	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("6"),numlinea,Short.parseShort("7")));//NOPMD
        	}
        	
        	rowTemp = sheet.getRow((short)n+11);
        	cell = row.getCell((short)1); 
        	cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        	cell = row.getCell((short)2);
        	cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        	
        	cell = row.getCell((short)3);
        	cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        	cell = row.getCell((short)4);
        	cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        	cell = row.getCell((short)5);
        	cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        	cell = row.getCell((short)6);
        	cell.setCellStyle(rowTemp.getCell((short)6).getCellStyle());
        	cell = row.getCell((short)7); 
        	cell.setCellStyle(rowTemp.getCell((short)7).getCellStyle());             
        	++numlinea;

        }

        
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=fichaIncidencias.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
}

